#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
    [TestFixture]
	public class BOL_LockManager : BaseTest 
	{

		private BOL.LockManager _tstLM;
        private int _lockFormId = -999;
        private int _baseLockFormId = -999;
        private bool _doOnlyOnce = true;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

            if (_doOnlyOnce)
            {
                this._tstLM = new LockManager(this._lockFormId, this._baseLockFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);
                this._tstLM.LockFunction = COMMON.LockFunctions.UnitTests;
                this._doOnlyOnce = false;
            }
		}

		[TearDown]
		protected void TearDown()
		{
		    this._tstLM.UnlockRecords();
		}


		[Test]
		public void Ctor_Pass()
		{
            int lockFormID = 0;
            int baseLockFormID = 0;
            BOL.LockManager tmpValue = new LockManager(lockFormID, baseLockFormID, BOL.LockManager.DefaultLockInactivityTimeoutMin);
			Assert.IsNotNull(tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ParameterlessMethod)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void IsRecordAlreadyLockedInUC_Pass()
		{			
			System.Guid recordGuid = System.Guid.NewGuid();

            this._tstLM.LockRecord(recordGuid, Common.LockFunctions.UnitTests, false);
            BOL.Lock tmpLock2 = this._tstLM.LockRecord(recordGuid, Common.LockFunctions.UnitTests,false);
			BOL.Lock tmpLock3;

			bool retValue = this._tstLM.IsRecordAlreadyLockedInUC(recordGuid, out tmpLock3);

			Assert.AreEqual(true, retValue, "ReturnValue");
            Assert.AreEqual(tmpLock2.LockedUseCase, tmpLock3.LockedUseCase, "LockedUseCase");
		}

		[Test]
		public void IsRecordAlreadyLockedInUC_Fail()
		{
			System.Guid recordGuid = System.Guid.NewGuid();
		    BOL.Lock tmpLock1;

			bool retValue = this._tstLM.IsRecordAlreadyLockedInUC(recordGuid, out tmpLock1);

			Assert.IsNull(tmpLock1, "IsNull");
			Assert.AreEqual(false, retValue, "IsRecordAlreadyLockedInUC");
		}

		[Test]
		public void GetLock_Pass()
		{		
			System.Guid recordGuid = System.Guid.NewGuid();
			
			this._tstLM.LockRecord(recordGuid, false);
			BOL.Lock tmpValue = BOL.LockManager.GetLock(recordGuid, true);

            Assert.AreEqual(recordGuid, tmpValue.LockedRecordGuid, "LockedRecordGuid");
			Assert.AreEqual(true, tmpValue.LockExists, "LockExists");
			Assert.AreEqual(false, tmpValue.LockConflictIndicator(this._lockFormId), "LockConflictIndicator");
		}

		[Test]
		public void GetLock_Fail()
		{
			System.Guid recordGuid = System.Guid.NewGuid();

			BOL.Lock tmpValue = BOL.LockManager.GetLock(recordGuid, false);

            Assert.AreEqual(System.Guid.Empty, tmpValue.LockedRecordGuid, "LockedRecordGuid");
			Assert.AreEqual(false, tmpValue.LockExists, "LockExists");
			Assert.AreEqual(false, tmpValue.LockConflictIndicator(12345), "LockConflictIndicator");
		}


		[Test]
		public void LockRecord_Pass()
		{
			System.Guid recordGuid = System.Guid.NewGuid();

			BOL.Lock tmpValue = this._tstLM.LockRecord(recordGuid, Common.LockFunctions.UnitTests, false);

            Assert.AreEqual(recordGuid, tmpValue.LockedRecordGuid, "LockedRecordGuid");
			Assert.AreEqual(true, tmpValue.LockExists, "LockExists");

			//Proving - locking the record a second time is ok
			int prevCount = this._tstLM.LockCount;
			BOL.Lock tmpValue2 = this._tstLM.LockRecord(recordGuid, Common.LockFunctions.UnitTests,false);
			Assert.AreEqual(prevCount, this._tstLM.LockCount, "LockCount");
			Assert.AreEqual(tmpValue.LockCreatedTime, tmpValue2.LockCreatedTime, "LockCreatedTime");

			//Code coverage for half of LockRecord cannot be done, due to the impracticle setup conditions needed
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void LockRecord_Fail()
		{
			//Impossible to hit the failing conditions, they require Sql problems, and record collisions
		}

		[Test]
		public void UnlockRecord_Pass()
		{
			System.Guid[] recordGuid = {System.Guid.NewGuid()};

			BOL.Lock tmpValue = this._tstLM.LockRecord(recordGuid[0], Common.LockFunctions.UnitTests,false);
			
			//Make sure the lock exists first
			if(tmpValue.LockExists)
			{
				this._tstLM.UnlockRecords(recordGuid, this._lockFormId, Common.LockFunctions.UnitTests);
				BOL.Lock tmpLock = BOL.LockManager.GetLock(recordGuid[0], false);
                Assert.AreEqual(System.Guid.Empty, tmpLock.LockedRecordGuid, "Unlock Failed");
			}
			else
				Assert.IsTrue(false, "Lock Failed");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnlockRecord_Fail()
		{
		}

		
		[Test]
		public void LockCount_Pass()
		{
			//Technically, this is unreachable code - the constructor sets the _locks object to a new ArrayList
			//The NULL test condition wanted here, cannot be reached
            BOL.LockManager tmpLM = new LockManager(543210, 543210, BOL.LockManager.DefaultLockInactivityTimeoutMin);
            tmpLM.LockFunction = COMMON.LockFunctions.UnitTests;
		   
            Assert.AreEqual(0, tmpLM.LockCount, "Default");

			System.Guid recGuid = System.Guid.NewGuid();

			tmpLM.LockRecord(recGuid, false);

			Assert.AreEqual(1, tmpLM.LockCount, "After Lock");

            tmpLM.UnlockRecords();
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LockCount_Fail()
		{
		}


		[Test]
		public void UnlockAllRecordsForUseCaseUser_Pass()
		{
			System.Guid recordGuid = System.Guid.NewGuid();

			this._tstLM.LockRecord(recordGuid, Common.LockFunctions.UnitTests, false);
			
			this._tstLM.UnlockAllRecordsForUseCaseUser(Common.LockFunctions.UnitTests, _lockFormId, _baseLockFormId);

			BOL.Lock tmpLock = BOL.LockManager.GetLock(recordGuid, false);

            Assert.AreEqual(System.Guid.Empty, tmpLock.LockedRecordGuid, "Unlock Failed");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnlockAllRecordsForUseCaseUser_Fail()
		{
		}


		[Test]
		public void UnlockAllRecordsForUser_Pass()
		{
			System.Guid recordGuid = System.Guid.NewGuid();

            this._tstLM.LockRecord(recordGuid, true);
			
			BOL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, true);

			BOL.Lock tmpLock = BOL.LockManager.GetLock(recordGuid, false);

            Assert.AreEqual(System.Guid.Empty, tmpLock.LockedRecordGuid, "UnlockAll Failed");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnlockAllRecordsForUser_Fail()
		{
		}


	}
}
#endif

